import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil
import com.liferay.portal.service.UserLocalServiceUtil
import com.liferay.portal.util.PortalUtil
import com.liferay.portal.kernel.workflow.WorkflowConstants
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil
import com.liferay.portlet.documentlibrary.model.DLFileEntry
import com.liferay.portlet.documentlibrary.model.DLFolder

def targerUserScreenName = "ses61062"
def targetDocUUID = "f8310477-b98d-e9ca-7850-939813c30e3f"

user = UserLocalServiceUtil.fetchUserByScreenName(PortalUtil.getDefaultCompanyId(), targerUserScreenName)
out.println("User: " + user.getFullName())

doc = DLFileEntryLocalServiceUtil.fetchDLFileEntryByUuidAndCompanyId(targetDocUUID, PortalUtil.getDefaultCompanyId())
out.println("Document: " + doc.getTitle() + " v" + doc.getVersion() + " (" + WorkflowConstants.getStatusLabel(doc.getStatus()) + ")")

permissionChecker = PermissionCheckerFactoryUtil.create(user)
out.println("User can VIEW doc? " + permissionChecker.hasPermission(doc.getGroupId(), DLFileEntry.class.getName(), doc.getPrimaryKey(), "VIEW"))
out.println("User can UPDATE doc? " + permissionChecker.hasPermission(doc.getGroupId(), DLFileEntry.class.getName(), doc.getPrimaryKey(), "UPDATE"))
out.println("User can VIEW doc as owner? " + permissionChecker.hasOwnerPermission(doc.getGroupId(), DLFileEntry.class.getName(), doc.getPrimaryKey(), user.getUserId(), "VIEW"))

folder = doc.getFolder();
out.println("Folder: " + folder.getName())

out.println("User can ACCESS folder? " + permissionChecker.hasPermission(folder.getGroupId(), DLFolder.class.getName(), folder.getPrimaryKey(), "ACCESS"))
out.println("User can VIEW folder? " + permissionChecker.hasPermission(folder.getGroupId(), DLFolder.class.getName(), folder.getPrimaryKey(), "VIEW"))